<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Pesan;
use App\Models\Rolepengeluaran;
use App\Models\Transaksi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    public function index()
    {
        $pesan = Pesan::latest('id', 'DESC')->limit(5)->get();
        $member = Member::latest('id', 'DESC')->limit(5)->get();
        $transaksi = Transaksi::latest('id', 'DESC')->limit(10)->get();
        $data = [
            'title' => 'Ramizah Store | Dashboard',
            'page' => 'Dashboard',
            'menuActive' => 'dashboard',
            'menuOpen' => 'dashboard',
        ];
        return view('admin.dashboard', compact('data', 'pesan', 'member', 'transaksi'))->with('no', 1);
    }

    public function data_penjualan(Request $request)
    {
        $tahun = $request->tahun;

        $order = Transaksi::where('jns_transaksi', 'ON')
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y')"), $tahun)
            ->where('sts_transaksi', 'N')->count();

        $transaksi = Transaksi::where('sts_transaksi', 'N')
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y')"), $tahun)
            ->count();

        $produk = Transaksi::join('keranjangs', 'keranjangs.transaksi_id', '=', 'transaksis.id')
            ->selectRaw('SUM(keranjangs.jumlah) as jml')
            ->where('sts_transaksi', 'N')
            ->where(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"), $tahun)
            ->groupBy(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"))
            ->first();

        $member = Transaksi::where('sts_transaksi', 'N')->where('member_id', '!=', 1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y')"), $tahun)
            ->groupBy(DB::raw("DATE_FORMAT(created_at, '%Y')"))
            ->count();


        $member_royal = Transaksi::where('sts_transaksi', 'N')->where('member_id', '!=', 1)
            ->join('members', 'members.id', '=', 'transaksis.member_id')
            ->where(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"), $tahun)
            ->selectRaw('SUM(total) as jml, members.nm_member as nm')
            ->groupBy('member_id')
            ->latest('jml', 'DESC')
            ->limit(10)
            ->get();


        function warna($w)
        {
            if ($w == 1) {
                $isi = '#7E0100';
            } elseif ($w == 2) {
                $isi = '#AB0001';
            } elseif ($w == 3) {
                $isi = '#CF0200';
            } elseif ($w == 4) {
                $isi = '#FF0100';
            } elseif ($w == 5) {
                $isi = '#FF2928';
            } elseif ($w == 6) {
                $isi = '#A70100';
            } elseif ($w == 7) {
                $isi = '#FE0000';
            } elseif ($w == 8) {
                $isi = '#FF5455';
            } elseif ($w == 9) {
                $isi = '#FE7A7C';
            } elseif ($w == 10) {
                $isi = '#FFBBB9';
            }
            return $isi;
        }

        $total = [];
        $nmmember = [];
        $nmmember2 = [];
        $w = 1;
        foreach ($member_royal as $m) {
            $total[] = $m->jml;
            $nmmember[] = $m->nm;
            $nmmember2[] = '<li><i class="far fa-circle ' . warna($w++) . '"></i> ' . $m->nm . '</li>';
        }
        // grafik
        if ($tahun == date('Y')) {
            $bln = date('m');
            $dttran = 'Transaksi : 1 Jan, ' . date('Y') . ' - ' . date('d M') . ', ' . date('Y');
        } else {
            $bln = '12';
            $dttran = 'Transaksi : 1 Jan, ' . date('Y') . ' -  12 Dec, ' . $tahun;
        }

        $cek_bulan = [];
        $pendapatan = [];
        $pengeluaran = [];
        $profit = [];
        $i = 1;
        while ($i <=  $bln) {
            $cek_bulan[] = format_bulan($tahun . '-' . $i);
            $p = Transaksi::where('sts_transaksi', 'N')->selectRaw('SUM(jumlah) as jml')->where(DB::raw("YEAR(created_at)"), $tahun)
                ->where(DB::raw("MONTH(created_at)"), $i)->groupBy(DB::raw("MONTH(created_at)"))->first();
            $pendapatan[] = (empty($p->jml)) ? 0 : $p->jml;
            $hp = (empty($p->jml)) ? 0 : $p->jml;

            $pg = Rolepengeluaran::where('sts_role', 'N')->selectRaw('SUM(total) as jml')->where(DB::raw("YEAR(created_at)"), $tahun)
                ->where(DB::raw("MONTH(created_at)"), $i)->groupBy(DB::raw("MONTH(created_at)"))->first();
            $pengeluaran[] = (empty($pg->jml)) ? 0 : $pg->jml;
            $hpg = (empty($pg->jml)) ? 0 : $pg->jml;

            $profit[] = $hp - $hpg;

            $i++;
        }

        $rata = array_sum($pendapatan) / $bln;

        if (!empty($order)) {
            $data = [
                'order' => number_format($order, 0, ',', '.'),
                'transaksi' => number_format($transaksi, 0, ',', '.'),
                'produk' =>  number_format($produk->jml, 0, ',', '.'),
                'member' => number_format($member, 0, ',', '.'),
                'dttran' => $dttran,
                'bulan' => $cek_bulan,
                'pendapatan' => $pendapatan,
                'pengeluaran' => $pengeluaran,
                'profit' => $profit,

                'nmmember' => $nmmember,
                'nmmember2' => $nmmember2,
                'total' => $total,

                'ttlp' => 'Rp. ' . number_format(array_sum($pendapatan), 0, ',', '.'),
                'ttlpg' => 'Rp. ' . number_format(array_sum($pengeluaran), 0, ',', '.'),
                'ttlpr' => 'Rp. ' . number_format(array_sum($profit), 0, ',', '.'),
                'rata' => 'Rp. ' . number_format($rata, 0, ',', '.'),
            ];
        } else {
            $data = [
                'order' => 0,
                'transaksi' => 0,
                'produk' =>  0,
                'member' => 0,
                'dttran' => $dttran,
                'bulan' => $cek_bulan,
                'pendapatan' => 0,
                'pengeluaran' => 0,
                'profit' => 0,

                'nmmember' => 0,
                'nmmember2' => "",
                'total' => 0,

                'ttlp' => 'Rp. 0',
                'ttlpg' => 'Rp. 0',
                'ttlpr' => 'Rp. 0',
                'rata' => 'Rp. 0',
            ];
        }
        return response()->json($data);
    }



    public function produk_terlaris(Request $request)
    {
        $tahun = $request->tahun;
        $transaksi = Transaksi::join('keranjangs', 'keranjangs.transaksi_id', '=', 'transaksis.id')
            ->join('produks', 'produks.id', '=', 'keranjangs.produk_id')
            ->where(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"), $tahun)
            ->where('sts_transaksi', 'N')
            ->selectRaw('SUM(keranjangs.jumlah) as jml, nm_produk as nm')
            ->groupBy("produk_id")
            ->latest('jml', 'DESC')
            ->limit(5)
            ->get();

        $item = Transaksi::join('keranjangs', 'keranjangs.transaksi_id', '=', 'transaksis.id')
            ->selectRaw('SUM(keranjangs.jumlah) as jml')
            ->where('sts_transaksi', 'N')
            ->where(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"), $tahun)
            ->groupBy(DB::raw("DATE_FORMAT(transaksis.created_at, '%Y')"))
            ->first();

        return view('admin.produk_terlaris', compact('transaksi', 'item'))->with('no', 1);
    }
}
